<?php
$pageTitle = "Project Details";
$pageDescription = "Project Details";
$currentPage = "projects";
include __DIR__ . '/includes/head.php';
include __DIR__ . '/includes/header.php';
?>

<!-- Page Header Section Start -->
<div class="page-header bg-section parallaxie" style="background-image: url('https://html.awaikenthemes.com/carvox/images/page-header-bg.jpg'); background-size: cover; background-repeat: no-repeat; background-attachment: fixed; background-position: center 9px;">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <!-- Page Header Box Start -->
        <div class="page-header-box">
          <h1 class="text-anime-style-3" data-cursor="-opaque">Last-Mile Delivery...</h1>
          <nav class="wow fadeInUp">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="index.php">home</a></li>
              <li class="breadcrumb-item"><a href="projects.php">projects</a></li>
              <li class="breadcrumb-item active" aria-current="page">Last-Mile Delivery...</li>
            </ol>
          </nav>
        </div>
        <!-- Page Header Box End -->
      </div>
    </div>
  </div>
</div>
<!-- Page Header Section End -->

<!-- Page Project Single Start -->
<div class="page-project-single">
  <div class="container">
    <div class="row">
      <div class="col-lg-4">
        <!-- Page Single Sidebar Start -->
        <div class="page-single-sidebar">
          <!-- Page Category List Start -->
          <div class="page-category-list project-category-list wow fadeInUp">
            <h3>Project Highlights</h3>
            <ul>
              <li><span>Project Type:</span>Supply Chain Optimization</li>
              <li><span>Duration:</span>January 2024 - June 2025</li>
              <li><span>Location:</span> North America & Europe</li>
              <li><span>Project Manager:</span>Darlene Robertson</li>
            </ul>
          </div>
          <!-- Page Category List End -->

          <!-- Sidebar CTA Box Start -->
          <div class="sidebar-cta-box wow fadeInUp" data-wow-delay="0.25s">
            <!-- Sidebar CTA Logo Start -->
            <div class="sidebar-cta-logo">
              <img src="./assets/img/TLS-Logo-white.png" alt="">
            </div>
            <!-- Sidebar CTA Logo End -->

            <!-- Sidebar CTA Content Start -->
            <div class="sidebar-cta-content">
              <h3>We're Here to Support Your Shipping Needs</h3>
              <p>We're committed to making your experience smooth, efficient, and hassle-free.</p>
            </div>
            <!-- Sidebar CTA Content End -->

            <!-- Sidebar CTA Contact Item Start -->
            <div class="sidebar-cta-contact-item">
              <h3><a href="tel:+9601234567">+960 123 4567</a></h3>
            </div>
            <!-- Sidebar CTA Contact Item End -->

            <!-- Sidebar CTA Button Start -->
            <div class="sidebar-cta-btn">
              <img src="./assets/img/icon-phone-white.svg" alt="">
            </div>
            <!-- Sidebar CTA Button End -->
          </div>
          <!-- Sidebar CTA Box End -->
        </div>
        <!-- Page Single Sidebar End -->
      </div>

      <div class="col-lg-8">
        <!-- Project Single Content Start -->
        <div class="project-single-content">
          <!-- Page Single Image Start -->
          <div class="page-single-image">
            <figure class="image-anime reveal">
              <img src="./assets/img/project-2.jpg" alt="">
            </figure>
          </div>
          <!-- Page Single Image End -->

          <!-- Project Entry Start -->
          <div class="project-entry">
            <p class="wow fadeInUp">The Last-Mile Delivery Network Expansion Project was designed to strengthen our delivery capabilities and bring faster, more efficient logistics solutions to customers across key urban and rural regions. By establishing new distribution hubs, optimizing delivery routes, and integrating advanced GPS tracking systems, we enhanced delivery speed, accuracy, and customer satisfaction.</p>

            <!-- Project Overview Box Start -->
            <div class="project-overview-box">
              <!-- Project Overview Content Start -->
              <div class="project-overview-content">
                <h2 class="text-anime-style-3">Project overview</h2>
                <p class="wow fadeInUp">The Last-Mile Delivery Network Expansion Project was initiated to enhance delivery efficiency, reduce transit times, and improve customer experience across our logistics operations.</p>
                <ul class="wow fadeInUp" data-wow-delay="0.2s">
                  <li>Added 25+ new regional and local delivery hubs.</li>
                  <li>Implemented AI-based tracking and smart route</li>
                  <li>Introduced electric vehicles to reduce carbon.</li>
                  <li>Reduced average delivery time by 35%.</li>
                </ul>
              </div>
              <!-- Project Overview Content End -->

              <!-- Project Overview Image Start -->
              <div class="project-overview-image">
                <figure class="imagea-anime reveal">
                  <img src="./assets/img/project-1.jpg" alt="">
                </figure>
              </div>
              <!-- Project Overview Image End -->
            </div>
            <!-- Project Overview Box End -->

            <!-- Project Benefit List Start -->
            <div class="project-benefit-list">
              <!-- Project Benefit List Item Start -->
              <div class="project-benefit-item wow fadeInUp">
                <div class="icon-box">
                  <img src="./assets/img/icon-service-1.svg" alt="">
                </div>
                <div class="project-benefit-item-content">
                  <h3>Lack of Real-Time Tracking</h3>
                </div>
              </div>
              <!-- Project Benefit List Item End -->

              <!-- Project Benefit List Item Start -->
              <div class="project-benefit-item wow fadeInUp" data-wow-delay="0.2s">
                <div class="icon-box">
                  <img src="./assets/img/icon-service-2.svg" alt="">
                </div>
                <div class="project-benefit-item-content">
                  <h3>Rising Operational Costs</h3>
                </div>
              </div>
              <!-- Project Benefit List Item End -->

              <!-- Project Benefit List Item Start -->
              <div class="project-benefit-item wow fadeInUp" data-wow-delay="0.4s">
                <div class="icon-box">
                  <img src="./assets/img/icon-service-3.svg" alt="">
                </div>
                <div class="project-benefit-item-content">
                  <h3>Infrastructure Limitations</h3>
                </div>
              </div>
              <!-- Project Benefit List Item End -->
            </div>
            <!-- Project Benefit List End -->

            <!-- Project Challenges Solutions Start -->
            <div class="project-challenges-solutions">
              <h2 class="text-anime-style-3">Challenges & solutions</h2>
              <p class="wow fadeInUp">Every major logistics transformation comes with unique challenges, and our Last-Mile Delivery Network Expansion Project was no exception. From managing growing delivery volumes to overcoming infrastructure and technology limitations,</p>

              <!-- Challenge Solution Boxes Start -->
              <div class="challenge-solution-boxes">
                <!-- Challenge Solution Item Start -->
                <div class="challenge-solution-item wow fadeInUp" data-wow-delay="0.2s">
                  <h3>Challenges</h3>
                  <p>The Last-Mile Delivery Network Expansion Project faced multiple operational and technological hurdles. Through strategic innovation, data-driven decisions,</p>
                  <ul>
                    <li>90% same-day or next-day service coverage</li>
                    <li>20% reduction in carbon emissions</li>
                    <li>40% improvement in delivery efficiency</li>
                  </ul>
                </div>
                <!-- Challenge Solution Item End -->

                <!-- Challenge Solution Item Start -->
                <div class="challenge-solution-item wow fadeInUp" data-wow-delay="0.4s">
                  <h3>Solutions</h3>
                  <p>The Last-Mile Delivery Network Expansion Project faced multiple operational and technological hurdles. Through strategic innovation, data-driven decisions,</p>
                  <ul>
                    <li>90% same-day or next-day service coverage</li>
                    <li>20% reduction in carbon emissions</li>
                    <li>40% improvement in delivery efficiency</li>
                  </ul>
                </div>
                <!-- Challenge Solution Item End -->
              </div>
              <!-- Challenge Solution Boxes End -->
            </div>
            <!-- Project Challenges Solutions End -->
          </div>
          <!-- Project Entry End -->
        </div>
        <!-- Project Single Content End -->
      </div>
    </div>
  </div>
</div>
<!-- Page Project Single End -->

<?php include __DIR__ . '/includes/footer.php'; ?>
<?php include __DIR__ . '/includes/scripts.php'; ?>