<?php
$pageTitle = "Home";
$pageDescription = "Welcome to TLS Maldives";
$currentPage = "home";
include __DIR__ . '/includes/head.php';
include __DIR__ . '/includes/header.php';
?>

<!-- Hero Section Start -->
<div class="hero bg-section dark-section parallaxie">
  <!-- Our Story Video Start -->
  <div class="hero-bg-video">
    <!-- Selfhosted Video Start -->
    <video autoplay muted loop playsinline preload="metadata" id="myvideo">
      <source
        src="https://demo.awaikenthemes.com/assets/videos/carvox-video.mp4"
        type="video/mp4" />
    </video>
    <!-- Selfhosted Video End -->
  </div>
  <!-- Our Story Video End -->

  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <div class="hero-content">
          <!-- Section Title Start -->
          <div class="section-title section-title-center">
            <h3 class="wow fadeInUp">Welcome to TLS Maldives</h3>
            <h1 class="text-anime-style-3" data-cursor="-opaque">
              Trusted Logistics Solutions Across the Maldives
            </h1>
          </div>
          <!-- Section Title End -->

          <!-- Section Content Button Start -->
          <div class="section-content-btn">
            <!-- Section Title Content Start -->
            <div
              class="section-title-content wow fadeInUp"
              data-wow-delay="0.2s">
              <p>
                Reliable shipping, freight forwarding, and marine services
                backed by 18 years of excellence. We ensure punctuality and
                trusted delivery for every shipment.
              </p>
            </div>
            <!-- Section Title Content End -->
            <!-- Section Button Start -->
            <div class="section-btn wow fadeInUp" data-wow-delay="0.4s">
              <a href="#contact" class="btn-default btn-highlighted">Request Logistics Support</a>
            </div>
            <!-- Section Button End -->
          </div>
          <!-- Section Content Button End -->
        </div>
      </div>

      <div class="col-lg-12">
        <!-- Hero Info List Start -->
        <div class="hero-info-list wow fadeInUp" data-wow-delay="0.6s">
          <ul>
            <li>Fast & Reliable Delivery</li>
            <li>24/7 Customer Support</li>
            <li>Cost-Effective Solutions</li>
            <li>Experienced Professionals</li>
            <li>On-Time Performance</li>
          </ul>
        </div>
        <!-- Hero Info List End -->
      </div>
    </div>
  </div>
</div>
<!-- Hero Section End -->

<!-- About Us Section Start -->
<div class="about-us" id="about">
  <div class="container">
    <div class="row section-row">
      <div class="col-lg-12">
        <!-- Section Title Start -->
        <div class="section-title section-title-center">
          <h3 class="wow fadeInUp">about us</h3>
          <h2 class="text-effect" data-cursor="-opaque">
            Delivering accuracy, reliability, and cost-effective logistics
            across the Maldives.
          </h2>
        </div>
        <!-- Section Title End -->
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4 col-md-6">
        <!-- About Us Image Box Start -->
        <div class="about-us-image-box wow fadeInUp">
          <div class="about-us-image">
            <figure class="image-anime">
              <img src="./assets/img/about-us-image.jpg" alt="" />
            </figure>
          </div>
          <div class="about-counter-box">
            <h2><span class="counter">24</span>/7</h2>
            <p>Customer Support</p>
          </div>
        </div>
        <!-- About Us Image Box End -->
      </div>

      <div class="col-xl-4 col-md-6">
        <!-- About Us Item Start -->
        <div class="about-us-item wow fadeInUp" data-wow-delay="0.2s">
          <div class="about-us-item-content">
            <h3>Extensive Inter-Atoll & Global Logistics Network</h3>
            <p>
              Connecting the Maldives and the world with reliable, secure,
              and efficient logistics solutions.
            </p>
          </div>
          <div class="about-us-body">
            <div class="about-counter-box">
              <h2><span class="counter">50</span>+</h2>
              <p>Global Partners</p>
            </div>
            <div class="about-us-body-image">
              <figure>
                <img src="./assets/img/about-us-body-image.png" alt="" />
              </figure>
            </div>
          </div>
        </div>
        <!-- About Us Item End -->
      </div>

      <div class="col-xl-4 col-md-6">
        <!-- About Us Item Start -->
        <div
          class="about-us-item highlighted-box wow fadeInUp"
          data-wow-delay="0.4s">
          <div class="about-us-item-content">
            <p>
              We combine innovation, reliability, and maritime expertise to
              provide trusted transportation solutions that ensure
              efficiency and safety.
            </p>
          </div>
          <div class="about-us-list-btn">
            <div class="about-us-item-list">
              <ul>
                <li>Punctual & On-Time Delivery</li>
                <li>Experienced & Dedicated Team</li>
              </ul>
            </div>
            <div class="about-us-item-btn">
              <a href="#services" class="btn-default btn-highlighted">Explore Our Services</a>
            </div>
          </div>
        </div>
        <!-- About Us Item End -->
      </div>

      <div class="col-lg-12">
        <!-- Section Footer Text Start -->
        <div class="section-footer-text wow fadeInUp" data-wow-delay="0.4s">
          <p>
            Partner with a logistics team that keeps the Maldives moving.
            <a href="#contact">Get Started</a>
          </p>
          <ul>
            <li><span class="counter">4.9</span>/5</li>
            <li>
              <i class="fa-solid fa-star"></i>
              <i class="fa-solid fa-star"></i>
              <i class="fa-solid fa-star"></i>
              <i class="fa-solid fa-star"></i>
              <i class="fa-solid fa-star"></i>
            </li>
            <li>Client Reviews</li>
          </ul>
        </div>
        <!-- Section Footer Text End -->
      </div>
    </div>
  </div>
</div>
<!-- About Us Section End -->

<!-- Our Services Section Start -->
<div class="our-services bg-section" id="services">
  <div class="container">
    <div class="row section-row">
      <div class="col-lg-12">
        <!-- Section Title Start -->
        <div class="section-title section-title-center">
          <h3 class="wow fadeInUp">Our Services</h3>
          <h2 class="text-anime-style-3" data-cursor="-opaque">
            Logistics services tailored for island and global operations
          </h2>
        </div>
        <!-- Section Title End -->
      </div>
    </div>

    <div class="row">
      <div class="col-xl-3 col-md-6">
        <!-- Services Item Start -->
        <div class="service-item service-box-1 wow fadeInUp">
          <div class="service-item-image">
            <a href="#services" data-cursor-text="View">
              <figure>
                <img src="./assets/img/service-1.jpg" alt="" />
              </figure>
            </a>
          </div>
          <div class="service-item-body">
            <div class="icon-box">
              <img src="./assets/img/icon-service-1.svg" alt="" />
            </div>
            <div class="service-item-content">
              <h3><a href="#services">Inter-Atoll Transportation</a></h3>
              <p>
                Reliable regional transport with modern fleets across the
                islands.
              </p>
            </div>
            <div class="service-item-btn">
              <a href="#services" class="readmore-btn">View Details</a>
            </div>
          </div>
        </div>
        <!-- Services Item End -->
      </div>

      <div class="col-xl-3 col-md-6">
        <!-- Services Item Start -->
        <div
          class="service-item service-box-2 wow fadeInUp"
          data-wow-delay="0.2s">
          <div class="service-item-image">
            <a href="#services" data-cursor-text="View">
              <figure>
                <img src="./assets/img/service-2.jpg" alt="" />
              </figure>
            </a>
          </div>
          <div class="service-item-body">
            <div class="icon-box">
              <img src="./assets/img/icon-service-2.svg" alt="" />
            </div>
            <div class="service-item-content">
              <h3><a href="#services">Air Express Freight</a></h3>
              <p>
                Time-critical air freight with SLA-backed delivery
                guarantees.
              </p>
            </div>
            <div class="service-item-btn">
              <a href="#services" class="readmore-btn">View Details</a>
            </div>
          </div>
        </div>
        <!-- Services Item End -->
      </div>

      <div class="col-xl-3 col-md-6">
        <!-- Services Item Start -->
        <div
          class="service-item service-box-3 wow fadeInUp"
          data-wow-delay="0.4s">
          <div class="service-item-image">
            <a href="#services" data-cursor-text="View">
              <figure>
                <img src="./assets/img/service-3.jpg" alt="" />
              </figure>
            </a>
          </div>
          <div class="service-item-body">
            <div class="icon-box">
              <img src="./assets/img/icon-service-3.svg" alt="" />
            </div>
            <div class="service-item-content">
              <h3><a href="#services">Marine Offshore Logistics</a></h3>
              <p>
                Sea marshalling and comprehensive offshore support services.
              </p>
            </div>
            <div class="service-item-btn">
              <a href="#services" class="readmore-btn">View Details</a>
            </div>
          </div>
        </div>
        <!-- Services Item End -->
      </div>

      <div class="col-xl-3 col-md-6">
        <!-- Services Item Start -->
        <div
          class="service-item service-box-4 wow fadeInUp"
          data-wow-delay="0.6s">
          <div class="service-item-image">
            <a href="#services" data-cursor-text="View">
              <figure>
                <img src="./assets/img/service-4.jpg" alt="" />
              </figure>
            </a>
          </div>
          <div class="service-item-body">
            <div class="icon-box">
              <img src="./assets/img/icon-service-4.svg" alt="" />
            </div>
            <div class="service-item-content">
              <h3>
                <a href="#services">International Freight Forwarding</a>
              </h3>
              <p>
                End-to-end forwarding with customs clearance and
                documentation.
              </p>
            </div>
            <div class="service-item-btn">
              <a href="#services" class="readmore-btn">View Details</a>
            </div>
          </div>
        </div>
        <!-- Services Item End -->
      </div>

      <div class="col-lg-12">
        <!-- Section Footer Text Start -->
        <div class="section-footer-text wow fadeInUp" data-wow-delay="0.4s">
          <p>
            <span>Free</span>Let's make something great together.
            <a href="#contact">Get Free Quote</a>
          </p>
        </div>
        <!-- Section Footer Text End -->
      </div>
    </div>
  </div>
</div>
<!-- Our Services Section End -->

<!-- Our Project Section Start -->
<div class="our-project">
  <div class="container">
    <div class="row section-row">
      <div class="col-lg-12">
        <div class="section-title section-title-center">
          <h3 class="wow fadeInUp">recent work</h3>
          <h2 class="text-anime-style-3" data-cursor="-opaque">
            Recent projects delivered across the Maldives
          </h2>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-lg-12">
        <div class="project-slider">
          <div class="swiper" id="tlsProjectSwiper">
            <div class="swiper-wrapper" data-cursor-text="Drag">
              <div class="swiper-slide">
                <div class="project-item">
                  <div class="project-item-image">
                    <a href="#" data-cursor-text="View">
                      <figure class="image-anime">
                        <img
                          src="./assets/img/project-1.jpg"
                          alt="Cold-chain delivery to resorts" />
                      </figure>
                    </a>
                  </div>
                  <div class="project-item-body">
                    <div class="project-item-tag">
                      <ul>
                        <li>Logistics</li>
                        <li>Maldives</li>
                      </ul>
                    </div>
                    <div class="project-item-content">
                      <h3>
                        <a href="#">Cold-chain delivery to resorts</a>
                      </h3>
                    </div>
                    <div class="project-item-btn">
                      <a href="#" class="readmore-btn">View Case Study</a>
                    </div>
                  </div>
                </div>
              </div>

              <div class="swiper-slide">
                <div class="project-item">
                  <div class="project-item-image">
                    <a href="#" data-cursor-text="View">
                      <figure class="image-anime">
                        <img
                          src="./assets/img/project-2.jpg"
                          alt="Inter-atoll cargo route optimization" />
                      </figure>
                    </a>
                  </div>
                  <div class="project-item-body">
                    <div class="project-item-tag">
                      <ul>
                        <li>Transportation</li>
                        <li>Inter-Atoll</li>
                      </ul>
                    </div>
                    <div class="project-item-content">
                      <h3>
                        <a href="#">Inter-atoll cargo route optimization</a>
                      </h3>
                    </div>
                    <div class="project-item-btn">
                      <a href="#" class="readmore-btn">View Case Study</a>
                    </div>
                  </div>
                </div>
              </div>

              <div class="swiper-slide">
                <div class="project-item">
                  <div class="project-item-image">
                    <a href="#" data-cursor-text="View">
                      <figure class="image-anime">
                        <img
                          src="./assets/img/project-3.jpg"
                          alt="Marine equipment transport & marshalling" />
                      </figure>
                    </a>
                  </div>
                  <div class="project-item-body">
                    <div class="project-item-tag">
                      <ul>
                        <li>Marine</li>
                        <li>Offshore</li>
                      </ul>
                    </div>
                    <div class="project-item-content">
                      <h3>
                        <a href="#">Marine equipment transport & marshalling</a>
                      </h3>
                    </div>
                    <div class="project-item-btn">
                      <a href="#" class="readmore-btn">View Case Study</a>
                    </div>
                  </div>
                </div>
              </div>

              <div class="swiper-slide">
                <div class="project-item">
                  <div class="project-item-image">
                    <a href="#" data-cursor-text="View">
                      <figure class="image-anime">
                        <img
                          src="./assets/img/project-4.jpg"
                          alt="Express air freight rollout" />
                      </figure>
                    </a>
                  </div>
                  <div class="project-item-body">
                    <div class="project-item-tag">
                      <ul>
                        <li>Air Freight</li>
                        <li>Express</li>
                      </ul>
                    </div>
                    <div class="project-item-content">
                      <h3><a href="#">Express air freight rollout</a></h3>
                    </div>
                    <div class="project-item-btn">
                      <a href="#" class="readmore-btn">View Case Study</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="project-pagination swiper-pagination"></div>
          </div>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="section-footer-text wow fadeInUp" data-wow-delay="0.4s">
          <p>
            Ready to plan your shipment?
            <a href="#contact">Get a Free Quote</a>
          </p>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Our Project Section End -->

<!-- Our Partner Section Start -->
<div class="our-partner">
  <div class="container">
    <div class="row">
      <div class="col-xl-6">
        <div class="our-partner-content">
          <!-- Section Title Start -->
          <div class="section-title">
            <h3 class="wow fadeInUp">world wide</h3>
            <h2 class="text-anime-style-3" data-cursor="-opaque">
              Your trusted partner for Maldivian & global logistics
            </h2>
            <p class="wow fadeInUp" data-wow-delay="0.2s">
              We deliver comprehensive transportation and logistics
              solutions. With inter-atoll reach and a global partner
              network, we keep shipments moving.
            </p>
          </div>
          <!-- Section Title End -->

          <!-- Partner Contact Info List Start -->
          <div
            class="partner-contact-info-list wow fadeInUp"
            data-wow-delay="0.4s">
            <!-- Partner Info Item Start -->
            <div class="partner-contact-info-item">
              <div class="icon-box">
                <img src="./assets/img/icon-phone-white.svg" alt="" />
              </div>
              <div class="partner-contact-info-content">
                <p>Need help? 24/7</p>
                <h3><a href="tel:+9601234567">+960 123 4567</a></h3>
              </div>
            </div>

            <div class="partner-contact-info-item">
              <div class="icon-box">
                <img src="./assets/img/icon-mail-white.svg" alt="" />
              </div>
              <div class="partner-contact-info-content">
                <p>E-mail us</p>
                <h3>
                  <a href="mailto:info@tlsmaldives.com">info@tlsmaldives.com</a>
                </h3>
              </div>
            </div>

            <div class="partner-contact-info-item location-info-item">
              <div class="icon-box">
                <img src="./assets/img/icon-location-white.svg" alt="" />
              </div>
              <div class="partner-contact-info-content">
                <p>Our Locations / Visit us</p>
                <h3>Malé, Maldives</h3>
              </div>
            </div>
          </div>
          <!-- Partner Contact Info List End -->
        </div>
      </div>

      <div class="col-xl-6">
        <div
          class="partner-world-map-box wow fadeInUp"
          data-wow-delay="0.2s">
          <div class="partner-world-map-image">
            <figure>
              <img src="./assets/img/world-map-image.png" alt="" />
            </figure>
          </div>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="world-map-counter-box wow fadeInUp">
          <div class="world-map-counter-item">
            <div class="icon-box">
              <img src="./assets/img/icon-world-map-counter-1.svg" alt="" />
            </div>
            <div class="world-map-counter-content">
              <h2><span class="counter">18</span>+</h2>
              <p>Years Of Experience</p>
            </div>
          </div>
          <div class="world-map-counter-item">
            <div class="icon-box">
              <img src="./assets/img/icon-world-map-counter-2.svg" alt="" />
            </div>
            <div class="world-map-counter-content">
              <h2><span class="counter">98</span>%</h2>
              <p>On-Time Delivery Rate</p>
            </div>
          </div>
          <div class="world-map-counter-item">
            <div class="icon-box">
              <img src="./assets/img/icon-world-map-counter-3.svg" alt="" />
            </div>
            <div class="world-map-counter-content">
              <h2><span class="counter">1</span>k+</h2>
              <p>Global Partnership</p>
            </div>
          </div>
          <div class="world-map-counter-item">
            <div class="icon-box">
              <img src="./assets/img/icon-world-map-counter-4.svg" alt="" />
            </div>
            <div class="world-map-counter-content">
              <h2><span class="counter">50</span>K+</h2>
              <p>Shipments Delivered</p>
            </div>
          </div>
          <div class="world-map-counter-item">
            <div class="icon-box">
              <img src="./assets/img/icon-world-map-counter-5.svg" alt="" />
            </div>
            <div class="world-map-counter-content">
              <h2><span class="counter">24</span>/7</h2>
              <p>Customer Support</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Our Partner Section End -->

<!-- How It Works Section Start -->
<div class="how-it-work bg-section" id="process">
  <div class="container">
    <div class="row section-row">
      <div class="col-lg-12">
        <div class="section-title section-title-center">
          <h3 class="wow fadeInUp">process</h3>
          <h2 class="text-anime-style-3" data-cursor="-opaque">
            How TLS Maldives works
          </h2>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-xl-3 col-md-6">
        <div class="how-work-item wow fadeInUp">
          <div class="how-work-item-header">
            <div class="how-work-item-image">
              <figure class="image-anime">
                <img
                  src="./assets/img/how-work-image-1.jpg"
                  alt="Consult & Plan" />
              </figure>
            </div>
            <div class="how-work-item-no">
              <h3>01</h3>
            </div>
          </div>
          <div class="how-work-item-content">
            <h3>Consult & Plan</h3>
            <p>
              We assess shipment needs, routes, and timing to design the
              most efficient logistics plan.
            </p>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6">
        <div class="how-work-item wow fadeInUp" data-wow-delay="0.2s">
          <div class="how-work-item-header">
            <div class="how-work-item-image">
              <figure class="image-anime">
                <img
                  src="./assets/img/how-work-image-2.jpg"
                  alt="Pickup & Handling" />
              </figure>
            </div>
            <div class="how-work-item-no">
              <h3>02</h3>
            </div>
          </div>
          <div class="how-work-item-content">
            <h3>Pickup & Handling</h3>
            <p>
              Secure pickup and professional handling with modern
              warehousing and tracking.
            </p>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6">
        <div class="how-work-item wow fadeInUp" data-wow-delay="0.4s">
          <div class="how-work-item-header">
            <div class="how-work-item-image">
              <figure class="image-anime">
                <img
                  src="./assets/img/how-work-image-3.jpg"
                  alt="Ship & Forward" />
              </figure>
            </div>
            <div class="how-work-item-no">
              <h3>03</h3>
            </div>
          </div>
          <div class="how-work-item-content">
            <h3>Ship & Forward</h3>
            <p>
              Inter-atoll and international forwarding with customs
              documentation handled end-to-end.
            </p>
          </div>
        </div>
      </div>

      <div class="col-xl-3 col-md-6">
        <div class="how-work-item wow fadeInUp" data-wow-delay="0.6s">
          <div class="how-work-item-header">
            <div class="how-work-item-image">
              <figure class="image-anime">
                <img
                  src="./assets/img/how-work-image-4.jpg"
                  alt="Deliver & Support" />
              </figure>
            </div>
            <div class="how-work-item-no">
              <h3>04</h3>
            </div>
          </div>
          <div class="how-work-item-content">
            <h3>Deliver & Support</h3>
            <p>
              On-time delivery with 24/7 customer support and transparent
              status updates.
            </p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- How It Works Section End -->

<!-- Our Faqs Section Start -->
<div class="our-faqs" id="faqs">
  <div class="container">
    <div class="row">
      <div class="col-xl-6">
        <div class="faqs-content">
          <div class="section-title">
            <h3 class="wow fadeInUp">help center</h3>
            <h2 class="text-anime-style-3" data-cursor="-opaque">
              Frequently asked questions
            </h2>
            <p class="wow fadeInUp" data-wow-delay="0.2s">
              Short answers to common questions about shipping, forwarding,
              and inter-atoll services.
            </p>
          </div>
        </div>
      </div>
      <div class="col-xl-6">
        <div class="faq-accordion our-faq-accordion" id="accordion-tls">
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">
              <button
                class="accordion-button"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#collapseOne"
                aria-expanded="true"
                aria-controls="collapseOne">
                What areas of the Maldives do you cover?
                <span
                  class="fa-solid fa-chevron-down accordion-icon"
                  aria-hidden="true"></span>
              </button>
            </h2>
            <div
              id="collapseOne"
              class="accordion-collapse collapse show"
              aria-labelledby="headingOne"
              data-bs-parent="#accordion-tls">
              <div class="accordion-body">
                We operate nationwide across all major atolls and remote
                islands, with partner routes for international forwarding.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingTwo">
              <button
                class="accordion-button collapsed"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#collapseTwo"
                aria-expanded="false"
                aria-controls="collapseTwo">
                Do you provide customs clearance and documentation?
                <span
                  class="fa-solid fa-chevron-down accordion-icon"
                  aria-hidden="true"></span>
              </button>
            </h2>
            <div
              id="collapseTwo"
              class="accordion-collapse collapse"
              aria-labelledby="headingTwo"
              data-bs-parent="#accordion-tls">
              <div class="accordion-body">
                Yes. Our forwarding service includes documentation, customs
                brokerage, and compliance support end-to-end.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingThree">
              <button
                class="accordion-button collapsed"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#collapseThree"
                aria-expanded="false"
                aria-controls="collapseThree">
                Can you handle time-critical shipments?
                <span
                  class="fa-solid fa-chevron-down accordion-icon"
                  aria-hidden="true"></span>
              </button>
            </h2>
            <div
              id="collapseThree"
              class="accordion-collapse collapse"
              aria-labelledby="headingThree"
              data-bs-parent="#accordion-tls">
              <div class="accordion-body">
                Absolutely. Our Air Express Freight provides SLA-backed
                delivery timelines with live tracking.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingFour">
              <button
                class="accordion-button collapsed"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#collapseFour"
                aria-expanded="false"
                aria-controls="collapseFour">
                Do you offer storage or warehousing?
                <span
                  class="fa-solid fa-chevron-down accordion-icon"
                  aria-hidden="true"></span>
              </button>
            </h2>
            <div
              id="collapseFour"
              class="accordion-collapse collapse"
              aria-labelledby="headingFour"
              data-bs-parent="#accordion-tls">
              <div class="accordion-body">
                Yes. We provide short-term storage and staging with careful
                handling and inventory controls.
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Our Faqs Section End -->

<!-- Our Testimonials Section Start -->
<div class="our-testimonials bg-section">
  <div class="container">
    <div class="row">
      <div class="col-xl-5">
        <div
          class="testimonial-image-box wow fadeInUp"
          data-wow-delay="0.2s">
          <div class="testimonial-image">
            <figure class="image-anime">
              <img src="./assets/img/testimonial-image.jpg" alt="" />
            </figure>
          </div>
          <div class="happy-customer-box">
            <div class="satisfy-client-images">
              <div class="satisfy-client-image">
                <figure class="image-anime">
                  <img src="./assets/img/author-1.jpg" alt="" />
                </figure>
              </div>
              <div class="satisfy-client-image">
                <figure class="image-anime">
                  <img src="./assets/img/author-2.jpg" alt="" />
                </figure>
              </div>
              <div class="satisfy-client-image">
                <figure class="image-anime">
                  <img src="./assets/img/author-3.jpg" alt="" />
                </figure>
              </div>
              <div class="satisfy-client-image add-more">
                <h3><span class="counter">10</span>k</h3>
              </div>
            </div>
            <div class="happy-customer-content">
              <p>Trusted by businesses across the Maldives</p>
            </div>
          </div>
        </div>
      </div>

      <div class="col-xl-7">
        <div class="testimonial-content-box">
          <div class="section-title">
            <h3 class="wow fadeInUp">Our Testimonials</h3>
            <h2 class="text-anime-style-3" data-cursor="-opaque">
              Hear from partners we proudly serve
            </h2>
          </div>
          <div class="testimonial-slider">
            <div class="swiper">
              <div class="swiper-wrapper" data-cursor-text="Drag">
                <div class="swiper-slide">
                  <div class="testimonial-item">
                    <div class="testimonial-company-logo">
                      <img src="./assets/img/company-logo-1.svg" alt="" />
                    </div>
                    <div class="testimonial-content">
                      <p>
                        “TLS Maldives ensured seamless deliveries to remote
                        atolls. Reliable, professional, and always on time.”
                      </p>
                    </div>
                    <div class="testimonial-author">
                      <div class="author-content">
                        <h3>Leslie Alexander</h3>
                        <p>CEO, Tech Startup</p>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="testimonial-item">
                    <div class="testimonial-company-logo">
                      <img src="./assets/img/company-logo-2.svg" alt="" />
                    </div>
                    <div class="testimonial-content">
                      <p>
                        “Outstanding logistics support for our events. The
                        TLS team was exceptional end-to-end.”
                      </p>
                    </div>
                    <div class="testimonial-author">
                      <div class="author-content">
                        <h3>Courtney Henry</h3>
                        <p>Events Director</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="testimonial-pagination swiper-pagination"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Our Testimonials Section End -->

<?php include __DIR__ . '/includes/footer.php'; ?>
<?php include __DIR__ . '/includes/scripts.php'; ?>