<?php
// Shared HTML <head> for all pages.
// Expects optional $pageTitle, $pageDescription, $pageKeywords.
$pageTitle = $pageTitle ?? 'TLS Maldives — Logistics & Transportation';
$pageDescription = $pageDescription ?? 'TLS Maldives — Trusted logistics and transportation solutions across the Maldives.';
$pageKeywords = $pageKeywords ?? 'TLS Maldives, logistics, transportation, freight, Maldives';
$pageAuthor = $pageAuthor ?? 'TLS Maldives';
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta
    name="viewport"
    content="width=device-width, initial-scale=1.0, maximum-scale=1" />
  <meta name="description" content="<?= htmlspecialchars($pageDescription, ENT_QUOTES) ?>" />
  <meta name="keywords" content="<?= htmlspecialchars($pageKeywords, ENT_QUOTES) ?>" />
  <meta name="author" content="<?= htmlspecialchars($pageAuthor, ENT_QUOTES) ?>" />
  <title><?= htmlspecialchars($pageTitle, ENT_QUOTES) ?></title>
  <link
    rel="shortcut icon"
    type="image/x-icon"
    href="assets/img/faviocn.png" />
  <!-- Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <!-- Bundled CSS -->
  <link href="./assets/css/bundle.css" rel="stylesheet" />
</head>

<body>
  <!-- Preloader Start -->
  <div class="preloader" style="display: none">
    <div class="loading-container">
      <div class="loading"></div>
      <div id="loading-icon">
        <img src="./assets/img/loader.svg" alt="" />
      </div>
    </div>
  </div>
  <!-- Preloader End -->